<?php
/* --------------------------------------------------------------
   StoredMultipleTrackingCodes.php 2020-04-07
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\Events;

use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeIds;

/**
 * Class StoredMultipleTrackingCodes
 *
 * @package Gambio\Admin\TrackingCode\Events
 */
class StoredMultipleTrackingCodes
{
    /**
     * @var TrackingCodeIds
     */
    private $trackingCodeIds;
    
    
    /**
     * StoredMultipleTrackingCodes constructor.
     *
     * @param TrackingCodeIds $trackingCodeIds
     */
    private function __construct(TrackingCodeIds $trackingCodeIds)
    {
        $this->trackingCodeIds = $trackingCodeIds;
    }
    
    
    /**
     * @param TrackingCodeIds $trackingCodeIds
     *
     * @return StoredMultipleTrackingCodes
     */
    public static function create(TrackingCodeIds $trackingCodeIds): StoredMultipleTrackingCodes
    {
        return new self($trackingCodeIds);
    }
    
    
    /**
     * @return TrackingCodeIds
     */
    public function trackingCodeIds(): TrackingCodeIds
    {
        return $this->trackingCodeIds;
    }
    
    
    /**
     * @param TrackingCodeIds $trackingCodeIds
     */
    public function replaceTrackingCodeIds(TrackingCodeIds $trackingCodeIds): void
    {
        $this->trackingCodeIds = $trackingCodeIds;
    }
}